<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title">
            <i class="fas fa-tv"></i> 1Stream Service Details
        </h3>
    </div>
    <div class="panel-body">
        
        {if $serviceType eq 'credits'}
            <!-- Reseller Credits Display -->
            <div class="alert alert-info">
                <i class="fas fa-info-circle"></i> This is a <strong>Reseller Credits</strong> account
            </div>
            
            <div class="service-details">
                <div class="detail-row">
                    <div class="detail-label"><i class="fas fa-user"></i> Reseller Name:</div>
                    <div class="detail-value"><strong>{$serviceData.name|default:'N/A'}</strong></div>
                </div>
                
                <div class="detail-row highlight">
                    <div class="detail-label"><i class="fas fa-coins"></i> Available Credits:</div>
                    <div class="detail-value">
                        <span class="badge badge-success badge-lg">{$serviceData.credits|default:'0'} Credits</span>
                    </div>
                </div>
            </div>
            
            {if $serverUrl}
            <div class="action-buttons">
                <a href="{$serverUrl}" target="_blank" class="btn btn-primary">
                    <i class="fas fa-external-link-alt"></i> Access Reseller Panel
                </a>
            </div>
            {/if}
            
        {else}
            <!-- Line/Subscription Display -->
            <div class="alert alert-info">
                <i class="fas fa-info-circle"></i> This is a <strong>Line/Subscription</strong> service
            </div>
            
            <div class="service-details">
                <div class="detail-row">
                    <div class="detail-label"><i class="fas fa-user"></i> Username:</div>
                    <div class="detail-value">
                        <strong><code id="username-field">{$username|default:$serviceData.username|default:'N/A'}</code></strong>
                        <button class="btn btn-xs btn-default" onclick="copyToClipboard('username-field')" title="Copy username">
                            <i class="fas fa-copy"></i>
                        </button>
                    </div>
                </div>
                
                <div class="detail-row">
                    <div class="detail-label"><i class="fas fa-key"></i> Password:</div>
                    <div class="detail-value">
                        <code id="password-field">••••••••</code>
                        <span id="password-actual" style="display:none;">{$password|default:$serviceData.password|default:'N/A'}</span>
                        <button class="btn btn-xs btn-default" onclick="togglePassword()" id="toggle-btn">
                            <i class="fas fa-eye"></i> Show
                        </button>
                        <button class="btn btn-xs btn-default" onclick="copyPassword()" title="Copy password">
                            <i class="fas fa-copy"></i>
                        </button>
                    </div>
                </div>
                
                {if $serviceData.line_id}
                <div class="detail-row">
                    <div class="detail-label"><i class="fas fa-id-card"></i> Line ID:</div>
                    <div class="detail-value"><small>{$serviceData.line_id}</small></div>
                </div>
                {/if}
                
                <div class="detail-row">
                    <div class="detail-label"><i class="fas fa-info-circle"></i> Status:</div>
                    <div class="detail-value">
                        {if $serviceData.is_enabled}
                            <span class="label label-success">Active</span>
                        {else}
                            <span class="label label-warning">Disabled</span>
                        {/if}
                    </div>
                </div>
                
                {if $serviceData.expire_at}
                <div class="detail-row">
                    <div class="detail-label"><i class="fas fa-calendar"></i> Expires:</div>
                    <div class="detail-value">{$serviceData.expire_at}</div>
                </div>
                {else}
                <div class="detail-row">
                    <div class="detail-label"><i class="fas fa-calendar"></i> Expires:</div>
                    <div class="detail-value"><span class="label label-info">Unlimited</span></div>
                </div>
                {/if}
                
                {if $serviceData.max_connections}
                <div class="detail-row">
                    <div class="detail-label"><i class="fas fa-link"></i> Max Connections:</div>
                    <div class="detail-value">{$serviceData.max_connections}</div>
                </div>
                {/if}
                
                {if $serviceData.package_id}
                <div class="detail-row">
                    <div class="detail-label"><i class="fas fa-box"></i> Package ID:</div>
                    <div class="detail-value">{$serviceData.package_id}</div>
                </div>
                {/if}
                
                {if $serviceData.type}
                <div class="detail-row">
                    <div class="detail-label"><i class="fas fa-tag"></i> Type:</div>
                    <div class="detail-value">
                        <span class="label label-default">{$serviceData.type|capitalize}</span>
                        {if $serviceData.is_trial}
                            <span class="label label-warning">Trial</span>
                        {/if}
                        {if $serviceData.is_restreamer}
                            <span class="label label-info">Restreamer</span>
                        {/if}
                    </div>
                </div>
                {/if}
                
                {if $serviceData.mac_addr}
                <div class="detail-row">
                    <div class="detail-label"><i class="fas fa-hdd"></i> MAC Address:</div>
                    <div class="detail-value"><code>{$serviceData.mac_addr}</code></div>
                </div>
                {/if}
                
                {if $serviceData.reseller_notes}
                <div class="detail-row">
                    <div class="detail-label"><i class="fas fa-sticky-note"></i> Notes:</div>
                    <div class="detail-value">{$serviceData.reseller_notes}</div>
                </div>
                {/if}
            </div>
            
            {if $serverUrl}
            <div class="action-buttons">
                <a href="{$serverUrl}" target="_blank" class="btn btn-primary">
                    <i class="fas fa-sign-in-alt"></i> Access 1Stream Panel
                </a>
            </div>
            {/if}
            
        {/if}
        
    </div>
</div>

<style>
    .service-details {
        margin: 15px 0;
    }
    
    .detail-row {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 12px 0;
        border-bottom: 1px solid #eee;
    }
    
    .detail-row:last-child {
        border-bottom: none;
    }
    
    .detail-row.highlight {
        background-color: #f9f9f9;
        padding: 12px 10px;
        margin: 0 -10px;
    }
    
    .detail-label {
        font-weight: 600;
        color: #666;
        flex: 0 0 180px;
    }
    
    .detail-value {
        flex: 1;
        text-align: right;
    }
    
    .detail-value code {
        background: #f5f5f5;
        padding: 4px 8px;
        border-radius: 3px;
        font-size: 13px;
    }
    
    .badge-lg {
        font-size: 16px;
        padding: 8px 12px;
    }
    
    .action-buttons {
        margin-top: 20px;
        text-align: center;
    }
    
    @media (max-width: 768px) {
        .detail-row {
            flex-direction: column;
            align-items: flex-start;
        }
        
        .detail-label {
            margin-bottom: 5px;
        }
        
        .detail-value {
            text-align: left;
            width: 100%;
        }
    }
</style>

<script>
function togglePassword() {
    var passwordField = document.getElementById('password-field');
    var passwordActual = document.getElementById('password-actual');
    var toggleBtn = document.getElementById('toggle-btn');
    
    if (passwordField.textContent === '••••••••') {
        passwordField.textContent = passwordActual.textContent;
        toggleBtn.innerHTML = '<i class="fas fa-eye-slash"></i> Hide';
    } else {
        passwordField.textContent = '••••••••';
        toggleBtn.innerHTML = '<i class="fas fa-eye"></i> Show';
    }
}

function copyPassword() {
    var passwordActual = document.getElementById('password-actual');
    var text = passwordActual.textContent;
    
    if (navigator.clipboard && navigator.clipboard.writeText) {
        navigator.clipboard.writeText(text).then(function() {
            alert('Password copied to clipboard!');
        }).catch(function(err) {
            fallbackCopy(text);
        });
    } else {
        fallbackCopy(text);
    }
}

function copyToClipboard(elementId) {
    var element = document.getElementById(elementId);
    var text = element.textContent;
    
    if (navigator.clipboard && navigator.clipboard.writeText) {
        navigator.clipboard.writeText(text).then(function() {
            alert('Copied to clipboard!');
        }).catch(function(err) {
            fallbackCopy(text);
        });
    } else {
        fallbackCopy(text);
    }
}

function fallbackCopy(text) {
    var textarea = document.createElement('textarea');
    textarea.value = text;
    textarea.style.position = 'fixed';
    textarea.style.opacity = 0;
    document.body.appendChild(textarea);
    textarea.select();
    try {
        document.execCommand('copy');
        alert('Copied to clipboard!');
    } catch (err) {
        alert('Failed to copy. Please copy manually.');
    }
    document.body.removeChild(textarea);
}
</script>
