<?php
/**
 * 1Stream Reseller WHMCS Provisioning Module - MANUAL SETUP
 * For managing reseller credit accounts with manual credential entry
 *
 * @copyright Copyright (c) 2024
 * @license MIT
 */

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

use WHMCS\Database\Capsule;

/**
 * Define module metadata
 */
function onestreamreseller_MetaData()
{
    return array(
        'DisplayName' => '1Stream Reseller',
        'APIVersion' => '1.1',
        'RequiresServer' => false, // No server needed for manual setup
        'DefaultNonSSLPort' => '80',
        'DefaultSSLPort' => '443',
        'ServiceSingleSignOnLabel' => 'Login to Reseller Panel',
    );
}

/**
 * Define product configuration options
 */
function onestreamreseller_ConfigOptions($params)
{
    return array(
        'Reseller Panel URL' => array(
            'Type' => 'text',
            'Size' => '50',
            'Default' => '',
            'Description' => 'The reseller panel URL (e.g., https://login.anonym0us.xyz)',
        ),
        'Stream DNS URL' => array(
            'Type' => 'text',
            'Size' => '50',
            'Default' => '',
            'Description' => 'Stream DNS URL shown to customers (e.g., http://stream.example.com:8080)',
        ),
    );
}

/**
 * Provision a new account (manual setup - does nothing automatically)
 */
function onestreamreseller_CreateAccount(array $params)
{
    // Manual setup - admin will add credentials manually
    // Just return success so the service can be activated
    return 'success';
}

/**
 * Suspend a service
 */
function onestreamreseller_SuspendAccount(array $params)
{
    // Manual management
    return 'success';
}

/**
 * Unsuspend a service
 */
function onestreamreseller_UnsuspendAccount(array $params)
{
    // Manual management
    return 'success';
}

/**
 * Terminate a service
 */
function onestreamreseller_TerminateAccount(array $params)
{
    // Manual management - admin handles in 1Stream panel
    return 'success';
}

/**
 * Client area output
 */
function onestreamreseller_ClientArea(array $params)
{
    try {
        $resellerUsername = $params['username'] ?? '';
        
        // Password handling - try to get from database, otherwise clients see default in template
        $resellerPassword = '';
        if (!empty($params['password'])) {
            try {
                $resellerPassword = decrypt($params['password']);
            } catch (Exception $e) {
                $resellerPassword = $params['password'];
            }
        }
        
        // Get configuration options
        $resellerPanelUrl = trim($params['configoption1'] ?? '');
        $streamDnsUrl = trim($params['configoption2'] ?? '');
        
        return array(
            'tabOverviewReplacementTemplate' => 'templates/onestreamreseller_clientarea.tpl',
            'templateVariables' => array(
                'serviceid' => $params['serviceid'],
                'resellerUsername' => $resellerUsername,
                'resellerPassword' => $resellerPassword, // Will be empty, template shows default
                'resellerPanelUrl' => $resellerPanelUrl,
                'streamDnsUrl' => $streamDnsUrl,
            ),
        );
        
    } catch (Exception $e) {
        logModuleCall('onestreamreseller', 'ClientArea_Exception', $params, $e->getMessage(), $e->getTraceAsString());
        return array(
            'tabOverviewReplacementTemplate' => 'templates/onestreamreseller_error.tpl',
            'templateVariables' => array('error' => $e->getMessage()),
        );
    }
}

/**
 * Admin services tab additional fields
 */
function onestreamreseller_AdminServicesTabFields(array $params)
{
    $fields = array();
    
    if (!empty($params['username'])) {
        $fields['Reseller Username'] = $params['username'];
    }
    
    if (!empty($params['configoption1'])) {
        $fields['Panel URL'] = $params['configoption1'];
    }
    
    if (!empty($params['configoption2'])) {
        $fields['Stream DNS'] = $params['configoption2'];
    }
    
    return $fields;
}

/**
 * Admin area output (for editing credentials)
 */
function onestreamreseller_AdminServicesTabFieldsSave(array $params)
{
    // This function allows saving of username/password from admin area
    // WHMCS handles this automatically through the service edit form
    return array();
}
